\version "2.16.0"

\paper {
  between-system-padding = 0\mm
  markup-system-spacing = #'((basic-distance . 2))
  left-margin = 1.5\cm
  line-width = 19.4\cm
  print-page-number = false
  top-margin = 5\mm
  ragged-last-bottom=##f
  system-count = #23
}

% diacritice: ă â î ş ţ Ţ Ş Ă Î

\header {
  title = "Concert"
  subtitle = "La Învierea Domnului"
  %subsubtitle = "Op. 5, variantă"
  composer = \markup \center-column { "Gavriil Musicescu" \small 
  "(1847–1903)" }
  %arranger = "io"
  meter = "Allegretto"
  tagline=""
}

global = {
  \key c \major
  \autoBeamOn
  %\cadenzaOn
  \time 4/4
  \set Staff.midiInstrument = "clarinet"
}

sopWords = \lyricmode {
  As -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră, 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  as -- tăzi tot tru -- pul,
  as -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te;
  că a în -- vi -- at Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat;
  că a în -- vi -- at că a în -- vi -- at 
  Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat şi ia -- dul s-a pră -- dat.
  
  Pe Ti -- ne Doam -- ne Dum -- ne -- ze -- u -- le în gla -- suri, 
  im -- nuri Te mă -- rim,
  Că pent -- tru nea -- mul, nea -- mul nos -- tru
  ai pri -- mit Cru -- cea şi moar -- tea.
  Că pent -- tru nea -- mul, nea -- mul nos -- tru
  ai pri -- mit Cru -- cea şi moar -- tea şi moar -- tea.
  
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  şi în -- vi -- ind a tre -- ia zi din groa -- pă
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne.
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne.  
}

altWords = \lyricmode {
  As -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  as -- tăzi tot tru -- pul,
  as -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  că a în -- vi -- at Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat;
  că a în -- vi -- at că a în -- vi -- at 
  Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat şi ia -- dul s-a pră -- dat. 
  
  Pe Ti -- ne Doam -- ne Dum -- ne -- ze -- u -- le în gla -- suri, 
  im -- nuri Te mă -- rim,
  Că pent -- tru nea -- mul, nea -- mul nos -- tru
  ai pri -- mit Cru -- cea şi moar -- tea.
  Pe Ti -- ne Doam -- ne Dum -- ne -- ze -- u -- le în gla -- suri, 
  im -- nuri Te mă -- rim,
  Că pent -- tru nea -- mul, nea -- mul nos -- tru
  ai pri -- mit Cru -- cea şi moar -- tea şi moar -- tea.
  
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind din groa -- pă,
  şi în -- vi -- ind a tre -- ia zi din groa -- pă,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne.
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind din groa -- pă,
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, 
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne. 
  
}

tenorWords = \lyricmode {
  As -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  as -- tăzi tot tru -- pul,
  as -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te, 
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  că a în -- vi -- at Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat;
  că a în -- vi -- at că a în -- vi -- at 
  Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat şi ia -- dul s-a pră -- dat. 
  
  Că pent -- tru nea -- mul, nea -- mul nos -- tru şi moar -- tea.
  Pe Ti -- ne Doam -- ne Dum -- ne -- ze -- u -- le în gla -- suri, 
  im -- nuri Te mă -- rim,
  Că pent -- tru nea -- mul, nea -- mul nos -- tru şi moar -- tea şi moar -- tea.
  
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  şi în -- vi -- ind a tre -- ia zi din groa -- pă
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne.
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, 
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai,
  ca un iu -- bi -- tor de oa -- meni,  Doam -- ne
}

bassWords = \lyricmode {
  As -- tăzi tot tru -- pul 
  se ve -- se -- leş -- te şi se bu -- cu -- ră
  as -- tăzi tot tru -- pul,
  as -- tăzi tot tru -- pul
  se ve -- se -- leş -- te şi se bu -- cu -- ră,
  se ve -- se -- leş -- te, se ve -- se -- leş -- te; 
  că a în -- vi -- at Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat;
  că a în -- vi -- at Hris -- tos, Hris -- tos, Hris -- tos
  şi ia -- dul s-a pră -- dat şi ia -- dul s-a pră -- dat. 
  
  Că pent -- tru nea -- mul, nea -- mul nos -- tru şi moar -- tea.
  Pe Ti -- ne Doam -- ne Dum -- ne -- ze -- u -- le în gla -- suri, 
  im -- nuri Te mă -- rim,
  Că pent -- tru nea -- mul, nea -- mul nos -- tru şi moar -- tea şi moar -- tea.

  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind din groa -- pă
  şi în -- vi -- ind a tre -- ia zi din groa -- pă,
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, Doam -- ne, Doam -- ne.
  Sfă -- râ -- mând por -- ţi -- le ia -- du -- lui
  şi în -- vi -- ind a tre -- ia zi, a tre -- ia zi din groa -- pă
  şi în -- vi -- ind din groa -- pă
  şi în -- vi -- ind şi în -- vi -- ind a tre -- ia zi din groa -- pă
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, 
  ca un iu -- bi -- tor de oa -- meni, 
  sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai, sal -- va -- tu -- ne-ai,
  ca un iu -- bi -- tor de oa -- meni,  Doam -- ne
  sal -- va -- tu -- ne-ai, ca un iu -- bi -- tor de oa -- meni,  
  Doam -- ne, Doam --ne.
}
  
sopMusic = \relative c'' {
  c4.^\f c8 e4( c) g' g g,^\p g8. g16 c2 c c4 c g g
  g c d e f8. f16 e8 f e([ d]) c([ b]) c4
  e2^\f c8.[ c16] b8.[ b16] b8[ c] e([ d]) c([ b]) c4 g'4. g8[ e( c)] 
  g' g d4. d8[ b( g)] d'4 d r2 r4 
  g,^\p a b c8. c16 c8 c b([ a]) g([ fis]) g4
  b c d e8. e16 d8 e d([ c]) b([ a]) b4
  d^\mf d g fis8. fis16 e8 d c4 b8([ a]) b4 d d d d1 d4
  d^\p c b8. b16 e2 r r4 b d( b) r e^\markup"cresc." g( e) r
  d g( d) r c^\mf c2( b) c b2. a4 g r r2 r4 c^\p b d8 d c4
  e^\f d f8 f e4 c^\p e( c) r f^\mf a( f) r e e( c) r
  f^\f f2( e) f e2. d4 c c^\markup"dim." c c c1( c2) b c r2 \fermata \bar "||"
  \time 3/4
  \key f \major
  \partial 8 <a c >8^\p^\markup "SOLI"^\markup "Andante"
  <c a >2 <g bes >4 <g bes >8.([ <f a >16]) <f a >4 r4 
  <d g >4( <g bes >) <f a > <f a >8.[ <g e>16] <e g >4 r8 <e g >8 
  <f a >4( <g bes >) <a c > <bes d >4 <a c >4. r8 
  <bes d >4.( <f' d>16 <e c> <bes d > <a c > <g bes >) 
  <f a > <f a >4( <e g >4.) r8
  bes'4^\pp bes bes a2 a4 bes2 bes4 bes8.( a16) a4 
  c8 c d4.( bes8) d c16 bes a2( g4) f2 \fermata r4 r1*3/4*9
  bes4^\pp bes bes a2 a4 bes2 bes4 bes8.( a16) a4 c8^\p c d4.( bes8) 
  d c16 bes a4( g2) f r8 bes a4( g2) f r4 \fermata
  \time 6/8
  \key c \major
  c'4.^\f( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r 
  e^\p e4 c8 c( d) e f4 f8 e4 e8 d4 d8 b( c) d e4. c4 
  g'8^\mf g4 e8 e4 g8^\f f4 d8 d4 g8^\mf g4 e8 e( f) g^\f f4. d4 b8 c4 c8 
  d4 d8 d4 d8 e4 e8 d2. d4. r4 <b d >8^\p 
  <b d>4.( <b d>8 <a c>8) <g b>8 <b g>4.( <b g>4) <c e>8 <c e>4.( <c e>8 
  <b d>8) <a c>8 <c a>4.( <a fis>4) r8 <a fis>4.( <a fis>8 <g b>8) <a c>8 
  <b g>4.( <b g>8 <c a>) <b d>8 <e c>4.( <e c>8 <b d>) <a c>8 
  <b g>4.( <a fis>4.) b r r1*6/8 r4 
  fis'8^\f g4 g8 a4 a8 g4 g8 fis4 fis8 g4 g8 fis4.( fis4) r8 
  g4.^\f g g g g g g fis g g g( fis) g2.( g4.) \fermata r4 r8 
  c,4.^\f( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r 
  e^\p e4 c8 c( d) e f4 f8 e4 e8 d4 d8 b( c) d e4. c4 
  g'8^\mf g4 e8 e4 g8^\f f4 d8 d4 g8^\mf g4 e8 e( f) g^\f f4. d4 b8 c4 c8 
  c4 c8 c4 c8 cis4 cis8 d4 d8 d4 d8 c4.( b) c4 r8 r4. r1*6/8*10 r4
  b8^\f c4 c8 d4 d8 c4 c8 b4 b8 c4 c8 b4.( b4) r8 
  c4.^\f c c c c c c4 c8 b4. c4 c8^\p c4 e8 e4 e8^\f e4 g8 g4. \fermata r4 r8
  c,4.^\f^\markup"A tempo" c d d c4 c8 b4 b8 c4 r8 b4 r8 
  c4.^\markup"rit"( b) c2. \fermata  
  \bar "|."
}

altMusic = \relative c'' {
  c4.^\f c8 e4( c) g g r2 r4
  <c, e>4^\p <d f> <e g> <f a>8. <f a>16 <e g>8 < f a> 
  <e g>([ <d f>]) <c e>([ <b d>]) <c e>4 e f g a8.[ a16] 
  g8[ a] g([ f]) e[( d]) e4
  c'2^\f g8.[ g16] g8.[ g16] g8 g g4 g g g4. g8[ e( c)]
  g' g d'4. d8[ b( g)] d'4 d d, d8. d16 g2 g g4 g d d
  d g a b c8. c16 c8 c b([ a]) g([ fis]) g4
  b^\mf g b a8. a16 g8 fis fis4 g8([ a]) g4 b g b 
  a8. a16 g8 fis fis4 g8([ a]) g4
  b^\p a g8. g16 c2 r r4 g b( g) r c^\markup"cresc." e( c) 
  r b b2 r4 a^\mf a2( g) a g fis g4 g g g8 g g1( g4)
  g^\f g g8 g g4 e^\p g( e) r a^\mf c( a) r g g( e) r
  d'^\f d2( c) d c2. b4 c g^\markup"dim." a a g1( g2.) f4 e2 r \fermata
  \time 3/4
  \key f \major
  \partial 8 f8 
  f2 cis4 d d r bes2 b4 c8. c16 c4 c f2 
  f4 e f4. r8 bes,2( bes8) bes c4( c4.) r8 
  g'4 g g f2 f4 g2 g4 g8.( f16) f4 a8 a bes4.( g8) 
  bes a16 g f2( e4) f2 \fermata r8 g^\f g2 f4 f8.( e16) e4. r8 a2 
  f4 e8. d16 d4 r8 d f4 d4. r8 g4 e4. r8 f4.( g8 bes16 a g f e4 d8[ e]) 
  f([ g]) e2 \fermata r4 
  g^\pp g g f2 f4 g2 g4 g8.( f16) f4 a8^\p a bes4.( g8) 
  bes a16 g f2( e4) f2 r8 g f2( e4) f2 r4 \fermata
  \time 6/8
  \key c \major
  c4.( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r8 
  g'^\p g4 e8 e( f) g a4 a8 g4 g8 f4 f8 d( e) f g4. g4 r8 r4 r8 r4 
  g8^\f g4 g8 g4 r8 r4 r8 r4 g8^\f g4. g4 g8 g4 g8 a4 a8 g4 g8 c4 c8 b4.( a) b r4 
  g8^\p g4. g g4.( g4) c,8 c4. c d4.( d4) r8 
  d4. d g g c, c d2. g4. r4 r8 r1*6/8 r4
  b8^\f b4 b8 c4 c8 b4 b8 a4 a8 b4 b8 a4.( a4) r8 
  b4.^\f b b b a a b a b b a2. b( b4.) \fermata  r4 r8 
  c,4.( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r8 
  g'^\p g4 e8 e( f) g a4 a8 g4 g8 f4 f8 d( e) f g4. g4 r8 r4 r8 r4 
  g8^\f g4 g8 g4 r8 r4 r8 r4 g8^\f g4. g4 g8 g4 g8 g4 g8 a4 
  a8 bes4 bes8 a4 a8 a4 a8 g2. g4. r4 
  g8^\p g4.( g8 f) e e4.( e4) a8 a4.( a8 g) f f4.( d4) r8 
  d4.( d8 e) f e4.( e8 f) g a4.( a8 g) f e4.( d) e r4 r8 r1*6/8*1 r4
  g8^\f g4 g8 b4 b8 c4 c8 g4 g8 g4 g8 g4.( g4) r8 
  g4.^\f g a a a a g4 g8 g4. g4 
  e8^\p e4 g8 g4 g8^\f g4 bes8 bes4. \fermata r4 r8 
  a4.^\f a a a g4 g8 g4 g8 g4 r8 g4 r8 g2. g \fermata  
}

tenorMusic = \relative c' {
  c4.^\f c8 e4( c) g' g r2 r1 r2 g,4 g8.[ g16] c2 c c4 c g g c
  g'2^\f e8.[ e16] d8.[ d16] d8[ e] g([ f]) e([ d]) e4 g4. g8[ e( c)]
  g' g d4. d8[ b( g)] d'4 d r2 r4 
  g,^\p a b e8. e16 d8 e d([ c]) b([ a]) b4 r r2 r1 r4
  d^\mf d d d1 d4 d d g fis8. fis16 e8 d c4 b8([ a]) b4 r r2 r4
  c^\p b a8. a16 d4 r r d^\markup"cresc." e( d) r g d( b) r b c( a) r
  d^\mf d2 c4( e) d2 c b4 r r2 r4
  e^\p d f8 f e4 c^\f b d8 d c4 r r e^\p f( d) r d^\mf e( c) r g' f( d) r
  g^\f g2( f4) a g2( f4) f e e^\markup"dim." d f e1( d2.) d4 c2 r \fermata
  \time 3/4
  \key f \major
  \partial 8 r8 
  r1*3/4*8
  c4 c c c2 c4 c2 c4 c c r r2 r8 r16 d c2( bes4) a2 \fermata r8 
  e'^\f e2 d4 d8.( c16) c4. r8 c2 d4 c8. b16 b4 r8 b d4 b4. r8 
  e4 c4. r8 d4.( e8 g16 f e d c2) b4 c2 \fermata r4 
  c^\pp c c c2 c4 c2 c4 c c r4 r2 r8 r16 d16 c2( bes4) a2 r8 d c2( bes4) a2 r4 \fermata
  \time 6/8
  \key c \major
  c4.^\f( c4)  e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c4 r8 r1*6/8*3 r4 r8 r4
  e8^\mf e4 c8 c4 e8^\f d4 b8 b4 e8^\mf e4 c8 c( d) e^\f d4. b4 
  d8 e4 e8 fis4 fis8 g4 g8 g4 g8 g4.( fis) g r4 r8
  r1*6/8*10 r4
  d8^\f d4 d8 fis4 fis8 g4 g8 d4 d8 d4 d8 d4.( d4) r8 
  d4.^\f d e e e e d d d e e( d) d2.( d4.) \fermata r4 r8
  c4.^\f( c4)  e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c4 r8 r1*6/8*3 r4 r8 r4
  e8^\mf e4 c8 c4 e8^\f d4 b8 b4 e8^\mf e4 c8 c( d) e^\f d4. b4 
  d8 e4 e8 e4 e8 f4 f8 e4 e8 f4 f8 f4 f8 e4.( d) e r4 
  e8^\p e4.( e8 d) c c4.( c4) f8 f4.( f8 e) d d4.( b4) r8 
  b4.( b8 c8) d c4.( c8 d) e f4.( f8 e) d c4.( b) c r4 r8 r1*6/8*1 r4
  d8^\f e4 e8 f4 f8 e4 e8 d4 d8 e4 e8 d4.( d4) r8 
  e4.^\f e e e d d e4 e8 d4. e4 r8 r4 r8 r4 
  c8^\f c4 e8 e4. \fermata r4 r8 
  f4.^\f f f f e4 e8 d4 d8 e4 r8 d4 r8 e4.( d) e2. \fermata  
}

bassMusic = \relative c {
  c4.^\f c8 e4( c) g' g r2 r1 r r r r4
  c2^\f c,8.[ e16] g8.[ g16] g8[ g] <g g,>4  <g g,> c, g'4. g8[ e( c)]
  g' g d'4. d8[ b( g)] d4 d r2 r1 r2 d4 d8. d16 g2 g g4 g d d g
  g,^\mf b g d'1 g4 g b g d'2( d,) g4 r r2 r4
  a^\p g fis8. fis16 b4 r r g^\markup"cresc." c( c,) r c g'( g,) r g' a( fis) r
  d^\mf g2 e4( c) d2 d g,4 r r2 r1 r4
  c'^\f g g8 g c4 r r c^\p a( f) r f^\mf c'( c,) r c' d( b) r
  g^\f c2( a4) f g2( <g a,>4) <g a,> c, e^\markup"dim." f d g1( g,2.) g4 c2 r \fermata
  \time 3/4
  \key f \major
  \partial 8 r8 
  r1*3/4*8
  c4 e c f( a) f e( g) e 
  <<
      {
        \voiceOne
        f8.( f,16) f4
      }
      \new Voice = "split" {
        \voiceTwo
        f'4 f,4
      }
  >>
  \oneVoice
  r4 r2 r8 r16 bes16 c2. f,2 \fermata r8 
  c'^\f c'2 aes4 a a,4. r8 f'2 f4 g8. g16 g4 r8 g g4 g4. r8 c4 c,4. r8 
  f2.( g2) g,4 c2 \fermata r4
  c^\pp e c f( a) f e( g) c, 
   <<
      {
        \voiceOne
        f8.( f,16) f4
      }
      \new Voice = "split" {
        \voiceTwo
        f'4 f,4
      }
  >>
  \oneVoice
  r4 r2 r8 r16 bes16 c2( cis4) d2 r8 bes c2. f,2 r4 \fermata
  \time 6/8
  \key c \major
  c'4.^\f( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r
  c8^\p c4 c8 c4 c8 c4 c8 c4 c8 g'4 g8 g4 g8 c,4. c4 r8 r4 r8 r4 
  c8^\f g'4 g,8 g4 r8 r4 r8 r4 
  c8^\f g'4. g4 g8 c4 c8 c4 c8 b4 b8 c4 a8 d4.( d,) g r4 r8 r1*6/8*8 r4
  g8^\f b4 g8 fis4 d8 g4 b8 d2.( d d4) d8 b4 g8 d4.( d4) r8 
  g4.^\f g8( b g) e4. e8( g e) c4. c8( e c) d4. d g e c( d) 
  <g g,>2.(  <g g,>4.) \fermata r4 r8
  c,4.^\f( c4) e8 g4.( g4 e8) f4( d8) b4 g8 c4 c8 c r
  c8^\p c4 c8 c4 c8 c4 c8 c4 c8 g'4 g8 g4 g8 c,4. c4 r8 r4 r8 r4 
  c8^\f g'4 g,8 g4 r8 r4 r8 r4 
  c8^\f g'4. g4 g8 c4 c8 bes4 bes8 a4 a8 g4 g8 f4 f8 f4 f8 g4.( g,) c4 r8 
  c4^\p r8 c4 r8 c4 r8 c4 r8 c4 r8 f4 r8 f4 r8 g4.( g4) r8 
  g4 r8 g4 r8 c,4 r8 c4 r8 f4 r8 f4 r8 g4.( g,) c4 
  c8^\f e4 c8 b4 g8 c4 e8 g2.( g g4) g8 e4 c8 g4.( g4) r8
  c'4. c8( e c) a4. a8( c a) f4. f8( a f) g4 g8 g4. c,4 r8 r4 r8 r4 
  c'8^\f c4 c,8 c4. \fermata r4 r8 
  f4.^\f f8( a f) d4. d8( f d) g4 g8 g4 g8 c,4 r8 g'4 r8 c4.( g) c,2. \fermata
}

myScore = \new Score <<
  \new ChoirStaff <<
    \new Staff <<
      \set Staff.instrumentName = #"S"  
      \new Voice { \global \sopMusic }
      \addlyrics { \sopWords }
    >>
    
    \new Staff <<
     \set Staff.instrumentName = #"A"  
     \new Voice { \global \altMusic }
     \addlyrics { \altWords  }
    >>
    
    \new Staff <<
     \set Staff.instrumentName = #"T"   
     \clef "G_8"
     \new Voice { \global \tenorMusic }
     \addlyrics { \tenorWords } 
    >>
    
    \new Staff <<
      \set Staff.instrumentName = #"B"    
      \clef bass
      \new Voice { \global \bassMusic }
      \addlyrics { \bassWords }
    >>
  >>
>>

\score {
  \myScore
  \layout { }
}

midiOutput = \midi {
  \tempo 4 = 60
  \context { \Voice \remove "Dynamic_performer" }
}

\score {
  \unfoldRepeats
  \myScore
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \sopMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \altMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \tenorMusic }
  \midi { \midiOutput }
}

\score {
  \unfoldRepeats
  \new Voice { \global \bassMusic }
  \midi { \midiOutput }
}
